/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.hypherionmc.simplerpclib.configuration.ClientConfig;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import me.hypherionmc.simplerpclib.configuration.ServerEntriesConfig;
import me.hypherionmc.simplerpclib.configuration.objects.Dimension;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceCore;
import shadow.hypherionmc.nightconfig.core.CommentedConfig;
import shadow.hypherionmc.nightconfig.core.Config;
import shadow.hypherionmc.nightconfig.core.UnmodifiableConfig;
import shadow.hypherionmc.nightconfig.core.conversion.ObjectConverter;
import shadow.hypherionmc.nightconfig.core.file.CommentedFileConfig;

public class ConfigEngine {
    private static final int VerNum = 13;
    private static final int ServerVerNum = 2;

    public static ClientConfig loadConfig(RichPresenceCore core) {
        File confDir = new File(core.getConfigPath() + "/config/");
        File langDir = new File(core.getConfigPath() + "/simple-rpc/");
        File defaultConf = new File(confDir.getAbsolutePath() + "/simple-rpc.toml");
        File translatedConf = new File(langDir.getAbsolutePath() + "/simple-rpc_" + core.getLangCode() + ".toml");
        if (!confDir.exists()) {
            confDir.mkdirs();
        }
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        ClientConfig clientConfig = null;
        try {
            File finalConfig;
            if (!defaultConf.exists()) {
                clientConfig = new ClientConfig();
                clientConfig.dimension_overrides.dimensions.add(new Dimension("overworld", "%player% is in The Overworld", "", "overworld", "In the Overworld", "mclogo", "%mods% mods installed"));
                clientConfig.dimension_overrides.dimensions.add(new Dimension("the_nether", "%player% is in The Nether", "", "nether", "In the Nether", "mclogo", "%mods% mods installed"));
                clientConfig.dimension_overrides.dimensions.add(new Dimension("the_end", "%player% is in The End", "", "end", "In the End", "mclogo", "%mods% mods installed"));
                ConfigEngine.saveConfig(clientConfig, defaultConf);
                RichPresenceCore.logger.warn("A config file has been created.\nPlease edit " + defaultConf.getAbsolutePath() + " to specify your RPC details");
            }
            File file = finalConfig = translatedConf.exists() ? translatedConf : defaultConf;
            if (finalConfig.exists()) {
                finalConfig = ConfigEngine.migrateConfig(finalConfig);
            }
            if ((clientConfig = ConfigEngine.loadConfig(finalConfig)) == null) {
                RichPresenceCore.logger.error("Could not load config file. Something unknown went wrong");
            } else {
                clientConfig.configPath = finalConfig.getAbsolutePath();
            }
        }
        catch (Exception e) {
            RichPresenceCore.logger.error("Could not load config file. Something unknown went wrong");
        }
        return clientConfig == null ? new ClientConfig() : clientConfig;
    }

    private static ClientConfig loadConfig(File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        config.load();
        return converter.toObject((UnmodifiableConfig)config, ClientConfig::new);
    }

    public static void saveConfig(Object conf, File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        converter.toConfig(conf, (Config)config);
        config.save();
    }

    private static File migrateConfig(File configFile) {
        Config.setInsertionOrderPreserved(true);
        CommentedFileConfig oldConfig = (CommentedFileConfig)CommentedFileConfig.builder(configFile).build();
        CommentedFileConfig newConfig = (CommentedFileConfig)CommentedFileConfig.builder(configFile).build();
        newConfig.load();
        newConfig.clear();
        oldConfig.load();
        if (oldConfig.getInt("general.version") != 13) {
            ObjectConverter converter = new ObjectConverter();
            converter.toConfig((Object)new ClientConfig(), (Config)newConfig);
            oldConfig.valueMap().forEach((s, o) -> {
                if (s.equalsIgnoreCase("world_images")) {
                    newConfig.set("dimension_overrides.enabled", oldConfig.get("world_images.enabled"));
                    List commentedConfigs = (List)oldConfig.get("world_images.worlds");
                    ArrayList newCommentedConfigs = new ArrayList();
                    if (!commentedConfigs.isEmpty()) {
                        commentedConfigs.forEach(commentedConfig -> {
                            CommentedConfig retConfig = CommentedConfig.inMemory();
                            retConfig.set("name", commentedConfig.get("worldname"));
                            retConfig.set("description", (Object)"");
                            retConfig.set("state", (Object)"");
                            retConfig.set("largeImageKey", commentedConfig.get("largeImageKey"));
                            retConfig.set("largeImageText", commentedConfig.get("largeImageText"));
                            retConfig.set("smallImageKey", commentedConfig.get("smallImageKey"));
                            retConfig.set("smallImageText", commentedConfig.get("smallImageText"));
                            newCommentedConfigs.add(retConfig);
                        });
                    }
                    newConfig.set("dimension_overrides.dimensions", newCommentedConfigs);
                } else if (!s.equalsIgnoreCase("updater")) {
                    if (o instanceof CommentedConfig) {
                        CommentedConfig config1 = (CommentedConfig)o;
                        config1.valueMap().forEach((ss, oo) -> newConfig.set(s + "." + ss, oo));
                    } else {
                        newConfig.set((String)s, o);
                    }
                }
            });
            configFile.renameTo(new File(configFile.getAbsolutePath().replace(".toml", ".bak")));
            newConfig.set("general.version", (Object)13);
            newConfig.save();
        }
        return newConfig.getFile();
    }

    public static ServerEntriesConfig loadServerEntries(RichPresenceCore core) {
        ServerEntriesConfig config = null;
        try {
            File langDir = new File(core.getConfigPath() + "/simple-rpc/");
            if (!langDir.exists()) {
                langDir.mkdirs();
            }
            File configFile = new File(langDir + "/server-entries_" + core.getLangCode() + ".toml");
            File configFile2 = new File(langDir + "/server-entries.toml");
            if (!configFile.exists() && !configFile2.exists()) {
                ServerEntriesConfig config1 = new ServerEntriesConfig();
                ConfigEngine.saveConfig(config1, configFile2);
            }
            if (configFile.exists() && (config = ConfigEngine.loadServerEntries(configFile)) != null) {
                config.configPath = configFile.getAbsolutePath();
            }
            if (!configFile.exists() && configFile2.exists() && (config = ConfigEngine.loadServerEntries(configFile2)) != null) {
                config.configPath = configFile2.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return config == null ? new ServerEntriesConfig() : config;
    }

    private static ServerEntriesConfig loadServerEntries(File configPath) {
        try {
            Config.setInsertionOrderPreserved(true);
            ObjectConverter converter = new ObjectConverter();
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
            config.load();
            return converter.toObject((UnmodifiableConfig)config, ServerEntriesConfig::new);
        }
        catch (Exception exception) {
            return new ServerEntriesConfig();
        }
    }

    public static ServerConfig loadServerConfig(String configPath) {
        ServerConfig config = null;
        try {
            File confDir = new File(configPath + "/config/");
            File configFile = new File(configPath + "/config/simple-rpc-server.toml");
            if (!confDir.exists()) {
                confDir.mkdirs();
            }
            if (!configFile.exists()) {
                ServerConfig conf = new ServerConfig();
                conf.dimension_overrides.dimensions.add(new Dimension("overworld", "%player% is in The Overworld", "", "overworld", "In the Overworld", "mclogo", "%mods% mods installed"));
                conf.dimension_overrides.dimensions.add(new Dimension("the_nether", "%player% is in The Nether", "", "nether", "In the Nether", "mclogo", "%mods% mods installed"));
                conf.dimension_overrides.dimensions.add(new Dimension("the_end", "%player% is in The End", "", "end", "In the End", "mclogo", "%mods% mods installed"));
                ConfigEngine.saveConfig(conf, configFile);
                RichPresenceCore.logger.error("A config file has been created.\nPlease edit " + configFile.getAbsolutePath() + " to specify your RPC details");
            }
            if (configFile.exists()) {
                configFile = ConfigEngine.migrateOldServerConfig(configFile);
            }
            if ((config = ConfigEngine.loadServerConfig(configFile)) == null) {
                RichPresenceCore.logger.error("Could not load config file. Something went wrong!");
            } else if (config.version < 2) {
                ConfigEngine.saveConfig(config, configFile);
                config = ConfigEngine.loadServerConfig(configFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return config == null ? new ServerConfig() : config;
    }

    private static ServerConfig loadServerConfig(File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        config.load();
        return converter.toObject((UnmodifiableConfig)config, ServerConfig::new);
    }

    public static File migrateOldServerConfig(File configFile) {
        Config.setInsertionOrderPreserved(true);
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFile).build();
        CommentedFileConfig config2 = (CommentedFileConfig)CommentedFileConfig.builder(configFile).build();
        config2.load();
        config2.clear();
        config.load();
        if (config.getInt("general.version") != 2) {
            ObjectConverter converter = new ObjectConverter();
            converter.toConfig((Object)new ServerConfig(), (Config)config2);
            config.valueMap().forEach((s, o) -> {
                if (s.equalsIgnoreCase("world_images")) {
                    config2.set("dimension_overrides.enabled", config.get("world_images.enabled"));
                    List commentedConfigs = (List)config.get("world_images.worlds");
                    ArrayList newCommentedConfigs = new ArrayList();
                    if (!commentedConfigs.isEmpty()) {
                        commentedConfigs.forEach(commentedConfig -> {
                            CommentedConfig retConfig = CommentedConfig.inMemory();
                            retConfig.set("name", commentedConfig.get("worldname"));
                            retConfig.set("description", (Object)"");
                            retConfig.set("state", (Object)"");
                            retConfig.set("largeImageKey", commentedConfig.get("largeImageKey"));
                            retConfig.set("largeImageText", commentedConfig.get("largeImageText"));
                            retConfig.set("smallImageKey", commentedConfig.get("smallImageKey"));
                            retConfig.set("smallImageText", commentedConfig.get("smallImageText"));
                            newCommentedConfigs.add(retConfig);
                        });
                    }
                    config2.set("dimension_overrides.dimensions", newCommentedConfigs);
                } else if (o instanceof CommentedConfig) {
                    CommentedConfig config1 = (CommentedConfig)o;
                    config1.valueMap().forEach((ss, oo) -> config2.set(s + "." + ss, oo));
                } else {
                    config2.set((String)s, o);
                }
            });
            configFile.renameTo(new File(configFile.getAbsolutePath().replace(".toml", ".bak")));
            config2.set("general.version", (Object)2);
            config2.save();
        }
        return config2.getFile();
    }
}

